require( "scripts/style.lua" );

kButtonSpacing = 60;	-- Put our buttons 60 pixels apart
kButtonY = kCenter-70;	-- Three buttons means center 60 pixels above the center

-- Style for upgrades

UpgradeButtonGraphics = {
	"",
	"",
	"icons/genericselect"
};

UpgradeButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = UpgradeButtonGraphics,
};

if gMode == "story" then
	options = prepareOptions(gLevel);
else
	options = prepareOptionsEndless(1);
end

images = {};
options_upgrade = {};
for i = 1, options, 1 do
	images[i] = getButton(i);
	options_upgrade[i] = getOption(i);
end 



StandardButtonFont2 = {
  standardFont,
  24,
  BlackColor
};


StandardButtonFont3 = {
  standardFont,
  24,
  BlackColor
};



UpgradeButtonGraphics1 = {
	images[1],
	images[1],
	images[1]
};
UpgradeButtonStyle1 = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = UpgradeButtonGraphics1,
};
UpgradeButtonGraphics2 = {
	images[2],
	images[2],
	images[2]
};
UpgradeButtonStyle2 = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = UpgradeButtonGraphics2,
};
UpgradeButtonGraphics3 = {
	images[3],
	images[3],
	images[3]
};
UpgradeButtonStyle3 = {
	parent 		= DefaultStyle,
	font 		= StandardButtonFont,
	sound 		= kDefaultButtonSound,
	type		= kPush,
	graphics 	= UpgradeButtonGraphics3,
};


Legends = {
	parent = ButtonStyle,
	font = StandardButtonFont3,
};

upgradeLevel_1 = getUpgradeValues(1);
upgradeLevel_2 = getUpgradeValues(2);
upgradeLevel_3 = getUpgradeValues(3);

upgradeMaxLevel_1 = getUpgradeMaxValues(1);
upgradeMaxLevel_2 = getUpgradeMaxValues(2);
upgradeMaxLevel_3 = getUpgradeMaxValues(3);

selectionGraphic_1 = getSelectionGraphic(1);
selectionGraphic_2 = getSelectionGraphic(2);
selectionGraphic_3 = getSelectionGraphic(3);

----- stars data --------------------------------------------------------------
imageStarsOn  = "gamepiece/star_full";
imageStarsOff = "gamepiece/star_notfull";

graphicElementsY = kButtonY + (kButtonSpacing ) - 30;
textElementsY    = graphicElementsY + 120 ;
starsPosY        = graphicElementsY - 80;

vFadeSpeed		 = 2.0;
vClickDone 		 = true;

if options == 3 then

	element1posX = kCenter - 180;
	element2posX = kCenter + 0;
	element3posX = kCenter + 180;

	MakeDialog
	{
		FunctionalUpgradesWindow
		{
			name	 = "funcupgradewin",
			x   	 = kCenter,
			y   	 = kCenter,
			w		 = kMax,
			h		 = kMax,
			fit 	 = true,
			fadeSpeed= vFadeSpeed;
			btnCount = options,
			starOn   = imageStarsOn,
			starOff  = imageStarsOff,
			
			Bitmap
			{
				-- Name the modal dialog ----------------------------------------------------------------
				-- BACKGROUND IMAGE ---------------------------------------------------------------				
				image	= "backgrounds/upgrades_background",
				x		= kCenter,
				y		= kCenter - 20,
			},
			
			
			-- TITLE -----------------------------------------------------------------------------------
			SetStyle(ButtonStyle),
			Text
			{
				x		= kCenter,
				y		= kButtonY - 140,
				w		= 300,
				h		= 100,
				flags 	= kVAlignCenter + kHAlignCenter,
				label 	= "upgrades_title",
				font    = TitleUpgradesFont,
			},
			-- FUNCTIONAL UPGRADE IMAGE (((1))) ------------------------------------------
			SetStyle(UpgradeButtonStyle1),
			FunctionalUpgradeButton
			{
				x				= element1posX,
				y				= graphicElementsY,
				--close 			= true,
				name			= "funcUpgradeOption1",
				upgradetext		= options_upgrade[1],
				upgradelevel	= upgradeLevel_1,
				upgrademaxlevel = upgradeMaxLevel_1,
				command			= function()
									if ( vClickDone == false ) then
										vClickDone = true;
										selectedOption(1);
										GameResumeFromUpgrades();
										FadeOutAndClose();
									end
								  end
			},
			-- FUNCTIONAL UPGRADE IMAGE (((2))) ------------------------------------------
			SetStyle(UpgradeButtonStyle2),
			FunctionalUpgradeButton
			{
				x				= element2posX,
				y				= graphicElementsY,
				--close 			= true,
				name			= "funcUpgradeOption2",
				upgradetext		= options_upgrade[2],
				upgradelevel	= upgradeLevel_2,
				upgrademaxlevel = upgradeMaxLevel_2,
					command		= function()
									if ( vClickDone == false ) then
										vClickDone = true;
										selectedOption(2);
										GameResumeFromUpgrades();
										FadeOutAndClose();
									end
								  end
			},
			-- FUNCTIONAL UPGRADE IMAGE (((3))) ------------------------------------------
			SetStyle(UpgradeButtonStyle3),
			FunctionalUpgradeButton
			{
				x				= element3posX,
				y				= graphicElementsY,
				--close 			= true,
				name			= "funcUpgradeOption3",
				upgradetext		= options_upgrade[3],
				upgradelevel	= upgradeLevel_3,
				upgrademaxlevel = upgradeMaxLevel_3,
					command		= function()
									if ( vClickDone == false ) then
										vClickDone = true;
										selectedOption(3);
										GameResumeFromUpgrades();
										FadeOutAndClose();
									end
								  end
			},
			--- SELECION GRAPHICS -----------------------------------------------------
			Bitmap 
			{
				name	= "overlaySelection1";
				x		= element1posX,
				y 		= graphicElementsY,
				image 	= selectionGraphic_1;
			},
			Bitmap 
			{
				name	= "overlaySelection2";
				x		= element2posX,
				y 		= graphicElementsY,
				image 	= selectionGraphic_2;
			},
			Bitmap 
			{
				name	= "overlaySelection3";
				x		= element3posX,
				y 		= graphicElementsY,
				image 	= selectionGraphic_3;
			},			
			-- GENERIC TEXT ((((1))))------------------------------------------------------
			SetStyle(ButtonStyle),
			Text
			{
				x 		= kCenter,
				y 		= textElementsY,
				w		= 400,
				h		= 80,
				flags 	= kVAlignCenter + kHAlignCenter,
				name	= "generictext1",
				text    = "",
				font	= StandardButtonFont2,
			},
			
		
		},
	}

elseif options == 2 then

	element1posX = kCenter -100;
	element2posX = kCenter +120;

	MakeDialog
	{
		FunctionalUpgradesWindow
		{
			name	 = "funcupgradewin",
			x   	 = kCenter,
			y   	 = kCenter,
			w		 = kMax,
			h		 = kMax,
			fit 	 = true,
			fadeSpeed= vFadeSpeed;
			btnCount = options,
			starOn   = imageStarsOn,
			starOff  = imageStarsOff,
			
			Bitmap
			{
				-- BACKGROUND IMAGE ---------------------------------------------------------------
				image	= "backgrounds/upgrades_background",
				x		= kCenter,
				y		= kCenter - 20,
			},
			
			-- TITLE -----------------------------------------------------------------------------------
			SetStyle(ButtonStyle),
			Text
			{
				x		= kCenter,
				y		= kButtonY - 140,
				w		= 300,
				h		= 100,
				flags 	= kVAlignCenter + kHAlignCenter,
				label 	= "upgrades_title",
				font    = TitleUpgradesFont,
			},
			-- FUNCTIONAL UPGRADE IMAGE (((1))) ------------------------------------------
			SetStyle(UpgradeButtonStyle1),
			FunctionalUpgradeButton
			{
				x				= element1posX,
				y				= graphicElementsY,
				--close 			= true,
				name			= "funcUpgradeOption1",
				upgradetext		= options_upgrade[1],
				upgradelevel	= upgradeLevel_1,
				upgrademaxlevel = upgradeMaxLevel_1,
					command		= function()
									if ( vClickDone == false ) then
										vClickDone = true;
										selectedOption(1);
										GameResumeFromUpgrades();
										FadeOutAndClose();
									end
								  end
			},
			-- FUNCTIONAL UPGRADE IMAGE (((2))) ------------------------------------------
			SetStyle(UpgradeButtonStyle2),
			FunctionalUpgradeButton
			{
				x				= element2posX,
				y				= graphicElementsY,
				--close 			= true,
				name			= "funcUpgradeOption2",
				upgradetext		= options_upgrade[2],
				upgradelevel	= upgradeLevel_2,
				upgrademaxlevel = upgradeMaxLevel_2,
					command		= function()
									if ( vClickDone == false ) then
										vClickDone = true;
										selectedOption(2);
										GameResumeFromUpgrades();
										FadeOutAndClose();
									end
								  end
			},
			--- SELECION GRAPHICS -----------------------------------------------------
			Bitmap 
			{
				name	= "overlaySelection1";
				x		= element1posX,
				y 		= graphicElementsY,
				image 	= selectionGraphic_1;
			},
			Bitmap 
			{
				name	= "overlaySelection2";
				x		= element2posX,
				y 		= graphicElementsY,
				image 	= selectionGraphic_2;
			},	
			-- GENERIC TEXT ((((1))))------------------------------------------------------
			SetStyle(ButtonStyle),
			Text
			{
				x 		= kCenter,
				y 		= textElementsY,
				w		= 400,
				h		= 80,
				flags 	= kVAlignCenter + kHAlignCenter,
				name	= "generictext1",
				text    = "",
				font	= StandardButtonFont2,
			},
		
		},
	}

else 

	element1posX = kCenter;

	MakeDialog
	{
		FunctionalUpgradesWindow
		{
			name	 = "funcupgradewin",
			x   	 = kCenter,
			y   	 = kCenter,
			w		 = kMax,
			h		 = kMax,
			fit 	 = true,
			fadeSpeed= vFadeSpeed;
			btnCount = options,
			starOn   = imageStarsOn,
			starOff  = imageStarsOff,
			
			Bitmap
			{
				-- BACKGROUND IMAGE ---------------------------------------------------------------
				image	= "backgrounds/upgrades_background",
				x		= kCenter,
				y		= kCenter - 20,
			},
			
			-- TITLE -----------------------------------------------------------------------------------
			SetStyle(ButtonStyle),
			Text
			{
				x		= kCenter,
				y		= kButtonY - 140,
				w		= 300,
				h		= 100,
				flags 	= kVAlignCenter + kHAlignCenter,
				label 	= "upgrades_title",
				font    = TitleUpgradesFont,
			},
			-- FUNCTIONAL UPGRADE IMAGE (((1))) ------------------------------------------
			SetStyle(UpgradeButtonStyle1),
			FunctionalUpgradeButton
			{
				x				= element1posX,
				y				= graphicElementsY,
				--close 			= true,
				name			= "funcUpgradeOption1",
				upgradetext		= options_upgrade[1],
				upgradelevel	= upgradeLevel_1,
				upgrademaxlevel = upgradeMaxLevel_1,
					command		= function()
									if ( vClickDone == false ) then
										vClickDone = true;
										selectedOption(1);
										GameResumeFromUpgrades();
										FadeOutAndClose();
									end
								  end
			},
			--- SELECION GRAPHICS -----------------------------------------------------
			Bitmap 
			{
				name	= "overlaySelection1";
				x		= element1posX,
				y 		= graphicElementsY,
				image 	= selectionGraphic_1;
			},
			-- GENERIC TEXT ((((1))))------------------------------------------------------
			SetStyle(ButtonStyle),
			Text
			{
				x 		= kCenter,
				y 		= textElementsY,
				w		= 400,
				h		= 80,
				flags 	= kVAlignCenter + kHAlignCenter,
				name	= "generictext1",
				text    = "",
				font	= StandardButtonFont2,
			},
		
		},
	}

end

SetFocus("funcupgradewin");
if gMode == "story" then
	GameInPauseDialog(false, false);
else 
	GameInPauseDialog(false, true);
end
